using System;
using System.Text;
using System.Management.Automation;
using System.Management.Automation.Provider;
using System.Management;

namespace de.ITVisions.PowerShell
{
 
 [Cmdlet(VerbsCommon.Get, "Disk2")]
 public class GetDiskCommand2 : PSCmdlet
 {
  //   [Parameter()]
  //[Parameter(Position = 0, ValueFromPipeline = true)]

  [Parameter(Position = 0, ValueFromPipeline = true)]
  public string Computer = ".";

  protected override void BeginProcessing()
  {
  }

  protected override void ProcessRecord()
  {
   string ABFRAGE = "Select * from Win32_Logicaldisk";

   System.Management.ManagementObjectCollection DiskMenge;
   ManagementScope ms = new ManagementScope("\\\\" + Computer + "\\root\\cimv2");
   ObjectQuery oq = new ObjectQuery(ABFRAGE);
   System.Management.ManagementObjectSearcher suche = new System.Management.ManagementObjectSearcher(ms, oq);
   DiskMenge = suche.Get();

   // Objekte einzeln zurckgeben
   this.WriteObject(DiskMenge, true);

   // Alternative
   //foreach (ManagementObject Disk in DiskMenge)
   //{
   // this.WriteObject(Disk);
   //}
  }

  protected override void StopProcessing()
  {
  }

 }
}
